///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _NEW_DB_H
#define _NEW_DB_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedClasses/CStatusDlg/CStatusDlg.H"

#include "../../SharedClasses/SQLClass/cSQL.H"
#include "../../SharedClasses/SQLClass/cRecordSet.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CreateNewDB(CSQL *lpMySQL, char *sDBName);
bool SetupNewClient(char *sClientDBFileName, char *sDBPrefix, char *sDBO, bool bImportStructure,
					bool bImportData, bool bDropImportTable, CStatusDlg *lpDlg);

bool RestoreDBForImport(CSQL *lpMySQL, char *sClientDBFileName, char *sDBName);
bool ImportDBStructure(CSQL *lpMySQL, char *sDBO, char *sDBName, bool bImportData, CStatusDlg *lpDlg);
bool CreateNewDBFromDBCreationScript(CSQL *lpMySQL, CSockSrvr *pSockSrvr, int iClient, char *sFileName);
bool CreateDatabaseIfNotExist(CSQL *lpMySQL, CSockSrvr *pSockSrvr, int iClient, const char *sDB);
bool GetDBNameFromBackup(CSQL *lpMySQL, const char *sBackupFile, char *sOut_DBName);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
